/*!---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
"use strict";
var ResultsImpl = (function () {
    function ResultsImpl() {
        this.resolved = [];
        this.results = [];
        this.failReasons = [];
    }
    return ResultsImpl;
}());
function tryAll(input) {
    if (input.length === 0) {
        return Promise.resolve(new ResultsImpl());
    }
    var internalInstance = new ResultsImpl();
    var promisesInProgress = [];
    var _loop_1 = function(i) {
        if (input[i] && input[i].then) {
            promisesInProgress.push(input[i].then(function (value) {
                internalInstance.results[i] = value;
                internalInstance.resolved[i] = true;
                return value;
            }, function (reason) {
                internalInstance.resolved[i] = false;
                internalInstance.failReasons[i] = reason;
            }));
        }
        else {
            internalInstance.resolved[i] = false;
            internalInstance.failReasons[i] = "Invalid Promise: " + JSON.stringify(input[i]);
        }
    };
    for (var i = 0; i < input.length; i++) {
        _loop_1(i);
    }
    var internalPromise = Promise.all(promisesInProgress)
        .then(function () {
        return internalInstance;
    }, function (reason) {
        return Promise.reject(reason);
    });
    return internalPromise;
}
exports.tryAll = tryAll;

// SIG // Begin signature block
// SIG // MIIh6gYJKoZIhvcNAQcCoIIh2zCCIdcCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // d1uXCtjFU1srptPh37pSpqte+fswaAhoBlw4kvnm24ug
// SIG // gguEMIIFDDCCA/SgAwIBAgITMwAAAU/nxmLJRvSpfwAA
// SIG // AAABTzANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDEwMB4XDTE2MTExNzIxNTkxNFoX
// SIG // DTE4MDIxNzIxNTkxNFowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBALSJkIp2DKzFPaG8gejXUAi7
// SIG // WmmnrsfMuFu9OA8hUUYII9G9Iplztyjv9werK/lI96UU
// SIG // BalNJBttYZacg50zwCx5mfBd8+zVRN+lzVn6dq0GP8ZK
// SIG // A+bqLZQQwmZv/WLQUIrRIpEjl2U0ocSaAl6S4rh8KHjC
// SIG // XuNG98rvOFeIrFYGWMqYG8eo1142rppFMOO2tz0Ywqcn
// SIG // sHlNU9gy5najUCr2P7q7QR4khk2Ym3qe9izivJBgZfuW
// SIG // afrgE2jiiSoudRidwm24IfSZXip/MaCnDczvTxFu/klC
// SIG // TmHeN8srnkDvzqtecAhzpXJ7t0bOWzJTXYo5UW+w16h4
// SIG // 3aMob17uQh8CAwEAAaOCAXswggF3MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjc9BgEGCCsGAQUFBwMDMB0GA1UdDgQWBBSS
// SIG // DqERcbYvVQ3DD/TJXHQuWgxqvzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwODY1
// SIG // K2I0YjEyODc4LWUyOTMtNDNlOS1iMjFlLTdkMzA3MTlk
// SIG // NDUyZjAfBgNVHSMEGDAWgBTm/F97uyIAWORyTrX0IXQj
// SIG // MubvrDBWBgNVHR8ETzBNMEugSaBHhkVodHRwOi8vY3Js
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9N
// SIG // aWNDb2RTaWdQQ0FfMjAxMC0wNy0wNi5jcmwwWgYIKwYB
// SIG // BQUHAQEETjBMMEoGCCsGAQUFBzAChj5odHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY0NvZFNp
// SIG // Z1BDQV8yMDEwLTA3LTA2LmNydDAMBgNVHRMBAf8EAjAA
// SIG // MA0GCSqGSIb3DQEBCwUAA4IBAQARwLlqQzX+hbE4gA24
// SIG // dHUsjXFJuDxB7S294gY2kHYrieW2gemG4xiMlpMyQqen
// SIG // 9rc0JTnQxnpD6tt3cMzU6ULrqMVVAnV4ntgQvgcbypRj
// SIG // +zwPce7UVWfXKfZqvwe85Y+C6vih4nMzPxSSXqG6ZVc3
// SIG // RYWAXNYsxos8aoejBxHL7NlxOCA1JD1UvcxVifR3EJvl
// SIG // maoPrsY8jp/aAE/PfeGzwCD3UjH3IkjVYY1/JgIZfYPM
// SIG // YZMq3bjc4gizp9/hBHdgyPSsNcsx5Wx1UcU3exNqTpVr
// SIG // j0CeyE0+rr1ZxSDWwnitt2RbO9DAFXA0FOXFnqYcx/T/
// SIG // 9stIweKN827OqrSgMIIGcDCCBFigAwIBAgIKYQxSTAAA
// SIG // AAAAAzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMC
// SIG // VVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcT
// SIG // B1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jw
// SIG // b3JhdGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3Qg
// SIG // Q2VydGlmaWNhdGUgQXV0aG9yaXR5IDIwMTAwHhcNMTAw
// SIG // NzA2MjA0MDE3WhcNMjUwNzA2MjA1MDE3WjB+MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQSAyMDEwMIIBIjANBgkqhkiG
// SIG // 9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6Q5kUHlntcTj/QkA
// SIG // TJ6UrPdWaOpE2M/FWE+ppXZ8bUW60zmStKQe+fllguQX
// SIG // 0o/9RJwI6GWTzixVhL99COMuK6hBKxi3oktuSUxrFQfe
// SIG // 0dLCiR5xlM21f0u0rwjYzIjWaxeUOpPOJj/s5v40mFfV
// SIG // HV1J9rIqLtWFu1k/+JC0K4N0yiuzO0bj8EZJwRdmVMkc
// SIG // vR3EVWJXcvhnuSUgNN5dpqWVXqsogM3Vsp7lA7Vj07IU
// SIG // yMHIiiYKWX8H7P8O7YASNUwSpr5SW/Wm2uCLC0h31oVH
// SIG // 1RC5xuiq7otqLQVcYMa0KlucIxxfReMaFB5vN8sZM4Bq
// SIG // iU2jamZjeJPVMM+VHwIDAQABo4IB4zCCAd8wEAYJKwYB
// SIG // BAGCNxUBBAMCAQAwHQYDVR0OBBYEFOb8X3u7IgBY5HJO
// SIG // tfQhdCMy5u+sMBkGCSsGAQQBgjcUAgQMHgoAUwB1AGIA
// SIG // QwBBMAsGA1UdDwQEAwIBhjAPBgNVHRMBAf8EBTADAQH/
// SIG // MB8GA1UdIwQYMBaAFNX2VsuP6KJcYmjRPZSQW9fOmhjE
// SIG // MFYGA1UdHwRPME0wS6BJoEeGRWh0dHA6Ly9jcmwubWlj
// SIG // cm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3RzL01pY1Jv
// SIG // b0NlckF1dF8yMDEwLTA2LTIzLmNybDBaBggrBgEFBQcB
// SIG // AQROMEwwSgYIKwYBBQUHMAKGPmh0dHA6Ly93d3cubWlj
// SIG // cm9zb2Z0LmNvbS9wa2kvY2VydHMvTWljUm9vQ2VyQXV0
// SIG // XzIwMTAtMDYtMjMuY3J0MIGdBgNVHSAEgZUwgZIwgY8G
// SIG // CSsGAQQBgjcuAzCBgTA9BggrBgEFBQcCARYxaHR0cDov
// SIG // L3d3dy5taWNyb3NvZnQuY29tL1BLSS9kb2NzL0NQUy9k
// SIG // ZWZhdWx0Lmh0bTBABggrBgEFBQcCAjA0HjIgHQBMAGUA
// SIG // ZwBhAGwAXwBQAG8AbABpAGMAeQBfAFMAdABhAHQAZQBt
// SIG // AGUAbgB0AC4gHTANBgkqhkiG9w0BAQsFAAOCAgEAGnTv
// SIG // V08pe8QWhXi4UNMi/AmdrIKX+DT/KiyXlRLl5L/Pv5PI
// SIG // 4zSp24G43B4AvtI1b6/lf3mVd+UC1PHr2M1OHhthosJa
// SIG // IxrwjKhiUUVnCOM/PB6T+DCFF8g5QKbXDrMhKeWloWmM
// SIG // IpPMdJjnoUdD8lOswA8waX/+0iUgbW9h098H1dlyACxp
// SIG // hnY9UdumOUjJN2FtB91TGcun1mHCv+KDqw/ga5uV1n0o
// SIG // UbCJSlGkmmzItx9KGg5pqdfcwX7RSXCqtq27ckdjF/qm
// SIG // 1qKmhuyoEESbY7ayaYkGx0aGehg/6MUdIdV7+QIjLcVB
// SIG // y78dTMgW77Gcf/wiS0mKbhXjpn92W9FTeZGFndXS2z1z
// SIG // NfM8rlSyUkdqwKoTldKOEdqZZ14yjPs3hdHcdYWch8Za
// SIG // V4XCv90Nj4ybLeu07s8n07VeafqkFgQBpyRnc89NT7be
// SIG // BVaXevfpUk30dwVPhcbYC/GO7UIJ0Q124yNWeCImNr7K
// SIG // sYxuqh3khdpHM2KPpMmRM19xHkCvmGXJIuhCISWKHC1g
// SIG // 2TeJQYkqFg/XYTyUaGBS79ZHmaCAQO4VgXc+nOBTGBpQ
// SIG // HTiVmx5mMxMnORd4hzbOTsNfsvU9R1O24OXbC2E9KteS
// SIG // LM43Wj5AQjGkHxAIwlacvyRdUQKdannSF9PawZSOB3sl
// SIG // cUSrBmrm1MbfI5qWdcUxghW+MIIVugIBATCBlTB+MQsw
// SIG // CQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQ
// SIG // MA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9z
// SIG // b2Z0IENvcnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3Nv
// SIG // ZnQgQ29kZSBTaWduaW5nIFBDQSAyMDEwAhMzAAABT+fG
// SIG // YslG9Kl/AAAAAAFPMA0GCWCGSAFlAwQCAQUAoIGsMBkG
// SIG // CSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwGCisGAQQB
// SIG // gjcCAQsxDjAMBgorBgEEAYI3AgEVMC8GCSqGSIb3DQEJ
// SIG // BDEiBCAonuTSRC7j6vjo9ZFhbJUuRjHrvJSopaFZinq+
// SIG // G4CTJDBABgorBgEEAYI3AgEMMTIwMKAWgBQAdAByAHkA
// SIG // LQBhAGwAbAAuAGoAc6EWgBRodHRwOi8vbWljcm9zb2Z0
// SIG // LmNvbTANBgkqhkiG9w0BAQEFAASCAQBXtQE1zlkoSv/g
// SIG // gk0nzodcj3MgwPGSw2GWtfEpQxhYC+fZb06LfZ+78Euo
// SIG // xt92QmKi+JD29hF3CWxv7UocQIZUOojg5w2mK8dMEv1J
// SIG // YQ7TmeItvQwEA2TISd1WPu4ZKY9MJIhbXZOd7dFbCa0k
// SIG // UmYL3JXzb/NuMwkaxAtyavRXU6/2hf52OpM6Ce3ceTVn
// SIG // NoQuchARdMde9nIcXLnghMRyCEPma+f8oq4gStDUROur
// SIG // wsSrW3VOGUxKGI9aQZrEsgRBxec9eenacKJL/ncy5aoP
// SIG // TIAv1QdKXDVd4Y/u1UbTQT0HN0b3uFkSSSloZiquP0eZ
// SIG // Ci/BqAOqwZhOhKU4mj6ToYITSjCCE0YGCisGAQQBgjcD
// SIG // AwExghM2MIITMgYJKoZIhvcNAQcCoIITIzCCEx8CAQMx
// SIG // DzANBglghkgBZQMEAgEFADCCAT0GCyqGSIb3DQEJEAEE
// SIG // oIIBLASCASgwggEkAgEBBgorBgEEAYRZCgMBMDEwDQYJ
// SIG // YIZIAWUDBAIBBQAEIN9XMuF6T7qQRq2CnsCbAuH+/0YX
// SIG // pskENMzIAIskfA0gAgZYPzFKOrAYEzIwMTYxMjI4MDA1
// SIG // ODAzLjcyNFowBwIBAYACAfSggbmkgbYwgbMxCzAJBgNV
// SIG // BAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYD
// SIG // VQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQg
// SIG // Q29ycG9yYXRpb24xDTALBgNVBAsTBE1PUFIxJzAlBgNV
// SIG // BAsTHm5DaXBoZXIgRFNFIEVTTjpGNTI4LTM3NzctOEE3
// SIG // NjElMCMGA1UEAxMcTWljcm9zb2Z0IFRpbWUtU3RhbXAg
// SIG // U2VydmljZaCCDs0wggZxMIIEWaADAgECAgphCYEqAAAA
// SIG // AAACMA0GCSqGSIb3DQEBCwUAMIGIMQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMTIwMAYDVQQDEylNaWNyb3NvZnQgUm9vdCBD
// SIG // ZXJ0aWZpY2F0ZSBBdXRob3JpdHkgMjAxMDAeFw0xMDA3
// SIG // MDEyMTM2NTVaFw0yNTA3MDEyMTQ2NTVaMHwxCzAJBgNV
// SIG // BAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYD
// SIG // VQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQg
// SIG // Q29ycG9yYXRpb24xJjAkBgNVBAMTHU1pY3Jvc29mdCBU
// SIG // aW1lLVN0YW1wIFBDQSAyMDEwMIIBIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAQ8AMIIBCgKCAQEAqR0NvHcRijog7PwTl/X6
// SIG // f2mUa3RUENWlCgCChfvtfGhLLF/Fw+Vhwna3PmYrW/AV
// SIG // UycEMR9BGxqVHc4JE458YTBZsTBED/FgiIRUQwzXTbg4
// SIG // CLNC3ZOs1nMwVyaCo0UN0Or1R4HNvyRgMlhgRvJYR4Yy
// SIG // hB50YWeRX4FUsc+TTJLBxKZd0WETbijGGvmGgLvfYfxG
// SIG // wScdJGcSchohiq9LZIlQYrFd/XcfPfBXday9ikJNQFHR
// SIG // D5wGPmd/9WbAA5ZEfu/QS/1u5ZrKsajyeioKMfDaTgaR
// SIG // togINeh4HLDpmc085y9Euqf03GS9pAHBIAmTeM38vMDJ
// SIG // RF1eFpwBBU8iTQIDAQABo4IB5jCCAeIwEAYJKwYBBAGC
// SIG // NxUBBAMCAQAwHQYDVR0OBBYEFNVjOlyKMZDzQ3t8RhvF
// SIG // M2hahW1VMBkGCSsGAQQBgjcUAgQMHgoAUwB1AGIAQwBB
// SIG // MAsGA1UdDwQEAwIBhjAPBgNVHRMBAf8EBTADAQH/MB8G
// SIG // A1UdIwQYMBaAFNX2VsuP6KJcYmjRPZSQW9fOmhjEMFYG
// SIG // A1UdHwRPME0wS6BJoEeGRWh0dHA6Ly9jcmwubWljcm9z
// SIG // b2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3RzL01pY1Jvb0Nl
// SIG // ckF1dF8yMDEwLTA2LTIzLmNybDBaBggrBgEFBQcBAQRO
// SIG // MEwwSgYIKwYBBQUHMAKGPmh0dHA6Ly93d3cubWljcm9z
// SIG // b2Z0LmNvbS9wa2kvY2VydHMvTWljUm9vQ2VyQXV0XzIw
// SIG // MTAtMDYtMjMuY3J0MIGgBgNVHSABAf8EgZUwgZIwgY8G
// SIG // CSsGAQQBgjcuAzCBgTA9BggrBgEFBQcCARYxaHR0cDov
// SIG // L3d3dy5taWNyb3NvZnQuY29tL1BLSS9kb2NzL0NQUy9k
// SIG // ZWZhdWx0Lmh0bTBABggrBgEFBQcCAjA0HjIgHQBMAGUA
// SIG // ZwBhAGwAXwBQAG8AbABpAGMAeQBfAFMAdABhAHQAZQBt
// SIG // AGUAbgB0AC4gHTANBgkqhkiG9w0BAQsFAAOCAgEAB+aI
// SIG // UQ3ixuCYP4FxAz2do6Ehb7Prpsz1Mb7PBeKp/vpXbRkw
// SIG // s8LFZslq3/Xn8Hi9x6ieJeP5vO1rVFcIK1GCRBL7uVOM
// SIG // zPRgEop2zEBAQZvcXBf/XPleFzWYJFZLdO9CEMivv3/G
// SIG // f/I3fVo/HPKZeUqRUgCvOA8X9S95gWXZqbVr5MfO9sp6
// SIG // AG9LMEQkIjzP7QOllo9ZKby2/QThcJ8ySif9Va8v/rbl
// SIG // jjO7Yl+a21dA6fHOmWaQjP9qYn/dxUoLkSbiOewZSnFj
// SIG // nXshbcOco6I8+n99lmqQeKZt0uGc+R38ONiU9MalCpaG
// SIG // pL2eGq4EQoO4tYCbIjggtSXlZOz39L9+Y1klD3ouOVd2
// SIG // onGqBooPiRa6YacRy5rYDkeagMXQzafQ732D8OE7cQnf
// SIG // XXSYIghh2rBQHm+98eEA3+cxB6STOvdlR3jo+KhIq/fe
// SIG // cn5ha293qYHLpwmsObvsxsvYgrRyzR30uIUBHoD7G4kq
// SIG // VDmyW9rIDVWZeodzOwjmmC3qjeAzLhIp9cAvVCch98is
// SIG // TtoouLGp25ayp0Kiyc8ZQU3ghvkqmqMRZjDTu3QyS99j
// SIG // e/WZii8bxyGvWbWu3EQ8l1Bx16HSxVXjad5XwdHeMMD9
// SIG // zOZN+w2/XU/pnR4ZOC+8z1gFLu8NoFA12u8JJxzVs341
// SIG // Hgi62jbb01+P3nSISRIwggTaMIIDwqADAgECAhMzAAAA
// SIG // sIbpkiAKXer4AAAAAACwMA0GCSqGSIb3DQEBCwUAMHwx
// SIG // CzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9u
// SIG // MRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNy
// SIG // b3NvZnQgQ29ycG9yYXRpb24xJjAkBgNVBAMTHU1pY3Jv
// SIG // c29mdCBUaW1lLVN0YW1wIFBDQSAyMDEwMB4XDTE2MDkw
// SIG // NzE3NTY1NloXDTE4MDkwNzE3NTY1NlowgbMxCzAJBgNV
// SIG // BAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYD
// SIG // VQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQg
// SIG // Q29ycG9yYXRpb24xDTALBgNVBAsTBE1PUFIxJzAlBgNV
// SIG // BAsTHm5DaXBoZXIgRFNFIEVTTjpGNTI4LTM3NzctOEE3
// SIG // NjElMCMGA1UEAxMcTWljcm9zb2Z0IFRpbWUtU3RhbXAg
// SIG // U2VydmljZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCC
// SIG // AQoCggEBAPDl8I2UWama12wJB3cUIVldtz14uDWt9TAx
// SIG // /87h/9bpGsmDmCP7kBDBkuw6vFBskL1c8WutTKL1YaWH
// SIG // 4SmsozwS33/EAILOvbQKX8u525q3GS1a7QcArVT9M6z2
// SIG // +BIkSiRnV9q4S6GsD4D5Ob0gDbWnxCxL8aFW5vIvJ7km
// SIG // wTMl2SsMMHJQhGuSapWM8voITbguJNVD09zr83RqiLPJ
// SIG // tGDcyWWtXwnlEWoUNMHkVwYSRuagvYRaJEJD9rz0LFWZ
// SIG // Wo2ziKaqEpQivoa1SomMqkewoMUfG4+c8GJtVJ0y06nE
// SIG // m1PpuXI7vxeer1hcncYrUCG72JbMNu+NpnPZrbtDcBUC
// SIG // AwEAAaOCARswggEXMB0GA1UdDgQWBBT8qAdS2e8p/phD
// SIG // PBVcdF63f3PgrzAfBgNVHSMEGDAWgBTVYzpcijGQ80N7
// SIG // fEYbxTNoWoVtVTBWBgNVHR8ETzBNMEugSaBHhkVodHRw
// SIG // Oi8vY3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9k
// SIG // dWN0cy9NaWNUaW1TdGFQQ0FfMjAxMC0wNy0wMS5jcmww
// SIG // WgYIKwYBBQUHAQEETjBMMEoGCCsGAQUFBzAChj5odHRw
// SIG // Oi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01p
// SIG // Y1RpbVN0YVBDQV8yMDEwLTA3LTAxLmNydDAMBgNVHRMB
// SIG // Af8EAjAAMBMGA1UdJQQMMAoGCCsGAQUFBwMIMA0GCSqG
// SIG // SIb3DQEBCwUAA4IBAQCS/YD3db1lkD4XzdUVg8WOApE7
// SIG // rE59YO+POQaTkOMPqkU9iT8C/exvuFCQCWyE0jchmbHB
// SIG // hnYd5A3Gjv8Y4KL6RrWFd3RuTgxERdC80rYEfnBLD9ar
// SIG // B2lWSnZk6PmqR6Ojhtz0z0S4SRBbZ4/R2nmuOt2HUwbo
// SIG // j2r8f9fko4ZFFQ2RYiI6kErj2GgBScktDmt4bBEC9I9N
// SIG // EWBzqAMhDZfjD3J1u/3oDrjr/CBBnY6T/cUzcz45er1q
// SIG // NB45R2IRtRzvV/Rzg3GfqBRlvuQDjk1txAEzG35X7KHz
// SIG // HJepOKf0qDo5+Yk1/F2jIq4KvY0MqzESbum9YRbs9Bk6
// SIG // JIViX6myoYIDdjCCAl4CAQEwgeOhgbmkgbYwgbMxCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xDTALBgNVBAsTBE1PUFIxJzAl
// SIG // BgNVBAsTHm5DaXBoZXIgRFNFIEVTTjpGNTI4LTM3Nzct
// SIG // OEE3NjElMCMGA1UEAxMcTWljcm9zb2Z0IFRpbWUtU3Rh
// SIG // bXAgU2VydmljZaIlCgEBMAkGBSsOAwIaBQADFQC8hPud
// SIG // WxLaxzaFO4hmnqMWGNXMHKCBwjCBv6SBvDCBuTELMAkG
// SIG // A1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAO
// SIG // BgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29m
// SIG // dCBDb3Jwb3JhdGlvbjENMAsGA1UECxMETU9QUjEnMCUG
// SIG // A1UECxMebkNpcGhlciBOVFMgRVNOOjU3RjYtQzFFMC01
// SIG // NTRDMSswKQYDVQQDEyJNaWNyb3NvZnQgVGltZSBTb3Vy
// SIG // Y2UgTWFzdGVyIENsb2NrMA0GCSqGSIb3DQEBBQUAAgUA
// SIG // 3A2ECDAiGA8yMDE2MTIyODAwMjEyOFoYDzIwMTYxMjI5
// SIG // MDAyMTI4WjB0MDoGCisGAQQBhFkKBAExLDAqMAoCBQDc
// SIG // DYQIAgEAMAcCAQACAgO/MAcCAQACAhfqMAoCBQDcDtWI
// SIG // AgEAMDYGCisGAQQBhFkKBAIxKDAmMAwGCisGAQQBhFkK
// SIG // AwGgCjAIAgEAAgMW42ChCjAIAgEAAgMHoSAwDQYJKoZI
// SIG // hvcNAQEFBQADggEBADK6pQkwkK45U28LOLA7FnXxWBqf
// SIG // HSg25lPn9o0zEIh1RB1hYZdFnuCJ3hU2UjSRZVEcGDZH
// SIG // nh4YwjPIMC7g2OFRt3dgj2NL55Mu7N5Ic357FI1ghQbj
// SIG // tYMW7Y5nUi/BW3CdXTXZOfXZ1h66r59kSwnjBlqL9BwY
// SIG // eFVKDOLCXY44+754utMK/LySbZ81FYBN8CSkyHlEqFY+
// SIG // BHNfpUvfqqfy+DuqJvPM4+Pq+aMb2DpHweOeJKD4izbn
// SIG // pJwfEexkQ1rh1ufqQP9ZUZRHFMAF9QRgZNj2EEQh82M6
// SIG // rL50H4bhHyTwCkMxKpPgn8wI6iLZ1c7UQmwizrCGeGWh
// SIG // 0lLcEhMxggL1MIIC8QIBATCBkzB8MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQgVGltZS1T
// SIG // dGFtcCBQQ0EgMjAxMAITMwAAALCG6ZIgCl3q+AAAAAAA
// SIG // sDANBglghkgBZQMEAgEFAKCCATIwGgYJKoZIhvcNAQkD
// SIG // MQ0GCyqGSIb3DQEJEAEEMC8GCSqGSIb3DQEJBDEiBCDW
// SIG // R6OdQAzCbtSj4SJFwl94oCwmlAADxTsrMroddHgLfzCB
// SIG // 4gYLKoZIhvcNAQkQAgwxgdIwgc8wgcwwgbEEFLyE+51b
// SIG // EtrHNoU7iGaeoxYY1cwcMIGYMIGApH4wfDELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWljcm9zb2Z0IFRp
// SIG // bWUtU3RhbXAgUENBIDIwMTACEzMAAACwhumSIApd6vgA
// SIG // AAAAALAwFgQUiuxRJ82n69xsA0yzhw1JuPv2LOgwDQYJ
// SIG // KoZIhvcNAQELBQAEggEAapSy7me5fZi7Nwa4QSXtxSJk
// SIG // /MKFmkmI4IFgHDgT1iTdCYGi6uYyxkxyVmiPM6MUjd2I
// SIG // 3AheyITbJXIajb1Qgr3qlx774tG1+iyGa7SI08NQdgOs
// SIG // txG1US9prF4rJGYY5AJ4nNaFYAUtAHwqgOUXH4kPU9Wt
// SIG // 76Rv7VLuc8QLaSB30Ze9JU6IhfG5LujPaCUx3tPilkNz
// SIG // FuPyndut9/8L/e3uztb8b/8MMDsp9i6KasVAB1P1muCx
// SIG // znbHFwjNFUoigXg/+VR8JZg+Nv2WtJX7kNxbwq45To46
// SIG // qXVntjIdMvRTj+619L0DkOU6aJcx0jtoGdUjYGAe6Ir3
// SIG // Ro8iHdf7NQ==
// SIG // End signature block
